﻿using CompositeMementoSample.Infrastructure;
using CompositeMementoSample.Models;
using CompositeMementoSample.ViewModels;
using Microsoft.Win32;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;

namespace CompositeMementoSample.Views
{
    /// <summary>
    /// Interaction logic for FileGroupView.xaml
    /// </summary>
    public partial class FileGroupView : UserControl
    {
        public ViewMode ViewMode
        {
            get { return (ViewMode)GetValue(ViewModeProperty); }
            set { SetValue(ViewModeProperty, value); }
        }

        public static readonly DependencyProperty ViewModeProperty =
            DependencyProperty.Register("ViewMode", typeof(ViewMode), typeof(FileGroupView), new FrameworkPropertyMetadata(ViewMode.Full));

        public string Title
        {
            get { return (string)GetValue(TitleProperty); }
            set { SetValue(TitleProperty, value); }
        }

        // Using a DependencyProperty as the backing store for Title.  This enables animation, styling, binding, etc...
        public static readonly DependencyProperty TitleProperty =
            DependencyProperty.Register("Title", typeof(string), typeof(FileGroupView), new PropertyMetadata(null));

        public FileGroupModel ActiveFileGroup
        {
            get { return (FileGroupModel)GetValue(ActiveFileGroupProperty); }
            set { SetValue(ActiveFileGroupProperty, value); }
        }

        public static readonly DependencyProperty ActiveFileGroupProperty =
            DependencyProperty.Register("ActiveFileGroup", typeof(FileGroupModel), typeof(FileGroupView), new FrameworkPropertyMetadata(null, OnActiveFileGroupChanged));

        private static void OnActiveFileGroupChanged(DependencyObject d, DependencyPropertyChangedEventArgs e)
        {
            ((FileGroupViewModel)((FileGroupView)d).DataContext).ActiveFileGroup = (FileGroupModel)e.NewValue;
        }

        public FileGroupView()
        {
            OpenSaveDialogInterface dialogInterface = new OpenSaveDialogInterface();
            this.DataContext = new FileGroupViewModel(dialogInterface, dialogInterface);
            InitializeComponent();

            string propertyInViewModel = "ViewMode";
            var bindingViewMode = new Binding(propertyInViewModel) { Mode = BindingMode.TwoWay };
            this.SetBinding(ViewModeProperty, bindingViewMode);

            propertyInViewModel = "ActiveFileGroup";
            var bindingActiveFileGroup = new Binding(propertyInViewModel) { Mode = BindingMode.TwoWay };
            this.SetBinding(ActiveFileGroupProperty, bindingActiveFileGroup);
        }
    }
}
