﻿using CompositeMementoSample.Infrastructure;
using CompositeMementoSample.Models;
using Microsoft.Practices.Prism.Commands;
using Microsoft.Practices.Prism.Mvvm;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Input;

namespace CompositeMementoSample.ViewModels
{
    public class MultiFileGroupViewModel : BindableBase
    {
        MultiFileGroupModel model;
        public MultiFileGroupModel Model
        {
            get { return model; }
            set 
            { 
                SetProperty(ref model, value);
                OnPropertyChanged(() => FileGroup1);
                OnPropertyChanged(() => FileGroup2);
                OnPropertyChanged(() => FileGroup3);
                OnPropertyChanged(() => FileGroup4);
            }
        }

        public FileGroupModel FileGroup1
        {
            get
            {
                return model.FileGroup1;
            }

            set
            {
                model.FileGroup1 = value;
                OnPropertyChanged(() => FileGroup1);
            }
        }

        public FileGroupModel FileGroup2
        {
            get
            {
                return model.FileGroup2;
            }

            set
            {
                model.FileGroup2 = value;
                OnPropertyChanged(() => FileGroup2);
            }
        }

        public FileGroupModel FileGroup3
        {
            get
            {
                return model.FileGroup3;
            }

            set
            {
                model.FileGroup3 = value;
                OnPropertyChanged(() => FileGroup3);
            }
        }

        public FileGroupModel FileGroup4
        {
            get
            {
                return model.FileGroup4;
            }

            set
            {
                model.FileGroup4 = value;
                OnPropertyChanged(() => FileGroup4);
            }
        }

        IOpenDialog OpenDialogService;
        ISaveDialog SaveDialogService;

        public MultiFileGroupViewModel(IOpenDialog OpenDialogService, ISaveDialog SaveDialogService)
        {
            Model = new MultiFileGroupModel();
            FileGroup1 = new FileGroupModel();
            FileGroup2 = new FileGroupModel();
            FileGroup3 = new FileGroupModel();
            FileGroup4 = new FileGroupModel();

            this.OpenDialogService = OpenDialogService;
            this.SaveDialogService = SaveDialogService;

            OpenDialogService.Filter = "Multi File Groups (*.mxml)|*.mxml";
            SaveDialogService.Filter = "Multi File Groups (*.mxml)|*.mxml";

            saveXmlCommand = new DelegateCommand(SaveXml);
            loadXmlCommand = new DelegateCommand(LoadXml);
        }

        DelegateCommand saveXmlCommand;
        public ICommand SaveXmlCommand
        {
            get { return saveXmlCommand; }
        }


        void SaveXml()
        {
            if (SaveDialogService.ShowSaveFileDialog() != true)
                return;

            Model.WriteToFile(SaveDialogService.SaveFileName);
        }

        DelegateCommand loadXmlCommand;
        public ICommand LoadXmlCommand
        {
            get { return loadXmlCommand; }
        }

        void LoadXml()
        {
            OpenDialogService.Multiselect = false;
            if (OpenDialogService.ShowOpenFileDialog() != true)
                return;

            MultiFileGroupModel newModel = MultiFileGroupModel.ReadFromFile(OpenDialogService.OpenFileName);
            if (newModel == null)
                return;

            Model = newModel;
        }
    }
}
