﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Runtime.Serialization;
using System.Text;
using System.Threading.Tasks;

namespace CompositeMementoSample.Models
{
    [DataContract]
    public class MultiFileGroupModel
    {
        [DataMember]
        public FileGroupModel FileGroup1 { get; set; }
        [DataMember]
        public FileGroupModel FileGroup2 { get; set; }
        [DataMember]
        public FileGroupModel FileGroup3 { get; set; }
        [DataMember]
        public FileGroupModel FileGroup4 { get; set; }

        public void WriteToFile(string Path)
        {
            using (MemoryStream memStm = new MemoryStream())
            using (StreamWriter outfile = new StreamWriter(Path))
            {
                DataContractSerializer ser = new DataContractSerializer(typeof(MultiFileGroupModel));
                ser.WriteObject(memStm, this);
                memStm.Seek(0, SeekOrigin.Begin);
                string result = new StreamReader(memStm).ReadToEnd();
                outfile.Write(result);
            }
        }

        public static MultiFileGroupModel ReadFromFile(string Path)
        {
            string contents = System.IO.File.ReadAllText(Path);
            using (Stream stream = new MemoryStream())
            {
                byte[] data = System.Text.Encoding.UTF8.GetBytes(contents);
                stream.Write(data, 0, data.Length);
                stream.Position = 0;
                DataContractSerializer deserializer = new DataContractSerializer(typeof(MultiFileGroupModel));
                object o = deserializer.ReadObject(stream);
                return o as MultiFileGroupModel;
            }
        }
    }
}
