﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Data;

namespace CompositeMementoSample.Infrastructure
{
    /// <summary>
    /// used by the AddInputsView for define a mode to handle which controls to show
    /// </summary>
    public enum ViewMode
    {
        Full,
        Compact
    }

    /// <summary>
    /// if the viewmode is ViewMode.Compact, will mark any controls with this converter as Visibility.Collapsed
    /// otherwise will mark control as Visible
    /// </summary>
    [ValueConversion(typeof(ViewMode), typeof(Visibility))]
    public class ViewModeToVisibilityConverter : IValueConverter
    {
        #region IValueConverter Members

        public object Convert(object value, Type targetType, object parameter, System.Globalization.CultureInfo culture)
        {
            if (targetType != typeof(Visibility))
                throw new InvalidOperationException("The target must be Visibility");

            ViewMode val = (ViewMode)value;

            if (val == ViewMode.Compact)
                return Visibility.Collapsed;
            return Visibility.Visible;
        }

        public object ConvertBack(object value, Type targetType, object parameter, System.Globalization.CultureInfo culture)
        {
            throw new NotImplementedException();
        }

        #endregion
    }

    /// <summary>
    /// if the viewmode is ViewMode.Compact, will mark any controls with this converter as Visibility.Visible
    /// </summary>
    [ValueConversion(typeof(ViewMode), typeof(Visibility))]
    public class InverseViewModeToVisibilityConverter : IValueConverter
    {
        #region IValueConverter Members

        public object Convert(object value, Type targetType, object parameter, System.Globalization.CultureInfo culture)
        {
            if (targetType != typeof(Visibility))
                throw new InvalidOperationException("The target must be Visibility");

            ViewMode val = (ViewMode)value;

            if (val == ViewMode.Compact)
                return Visibility.Visible;
            return Visibility.Collapsed;
        }

        public object ConvertBack(object value, Type targetType, object parameter, System.Globalization.CultureInfo culture)
        {
            throw new NotImplementedException();
        }

        #endregion
    }
}
