﻿using Microsoft.Win32;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace CompositeMementoSample.Infrastructure
{
    public class OpenSaveDialogInterface : IOpenDialog, ISaveDialog
    {
        #region IOpenDialog Members

        public string Filter
        {
            get;
            set;
        }

        public string OpenFileName
        {
            get;
            set;
        }

        public string[] OpenFileNames
        {
            get;
            set;
        }

        public bool Multiselect
        {
            get;
            set;
        }

        public bool? ShowOpenFileDialog()
        {
            OpenFileDialog ofd = new OpenFileDialog();
            ofd.Filter = Filter;
            ofd.Multiselect = Multiselect;
            bool? result = ofd.ShowDialog();
            if (result == true)
            {
                OpenFileName = ofd.FileName;
                OpenFileNames = ofd.FileNames;
            }
            return result;
        }

        #endregion

        #region ISaveDialog Members

        public string SaveFileName
        {
            get;
            set;
        }

        public bool? ShowSaveFileDialog()
        {
            SaveFileDialog sfd = new SaveFileDialog();
            sfd.Filter = Filter;
            bool? result = sfd.ShowDialog();
            if (result == true)
            {
                SaveFileName = sfd.FileName;
            }
            return result;
        }

        #endregion
    }
}
